/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.servlet.util.HMCCustomScopeListener;
import com.ibm.ps.wcl.core.scope.custom.CustomScopeBindingEvent;
import com.ibm.ps.wcl.core.scope.custom.ICustomScope;
import com.ibm.ps.wcl.core.scope.custom.ICustomScopeBindingListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HMCCustomScope
implements ICustomScope {
    HashMap attributes = new HashMap();
    String scopeName;
    Object attachment;
    List scopeListeners;
    static long customScopeIdSequence;

    public HMCCustomScope() {
        this(HMCCustomScope.assignName());
    }

    public HMCCustomScope(Object attachment) {
        this(HMCCustomScope.assignName(), attachment);
    }

    private static synchronized String assignName() {
        return "util.customscope." + Long.toString(++customScopeIdSequence);
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public HMCCustomScope(String scopeName) {
        this(scopeName, null);
    }

    public HMCCustomScope(String scopeName, Object attachment) {
        this.scopeName = scopeName;
        this.attachment = attachment;
    }

    public synchronized void setAttribute(String name, Object attribute) {
        CustomScopeBindingEvent event;
        Object old = this.attributes.put(name, attribute);
        if (old != null) {
            this.fireAttributeRemoved(name, old);
            if (old instanceof ICustomScopeBindingListener) {
                event = new CustomScopeBindingEvent((ICustomScope)this, name);
                ((ICustomScopeBindingListener)old).valueUnbound(event);
            }
        }
        if (attribute instanceof ICustomScopeBindingListener) {
            event = new CustomScopeBindingEvent((ICustomScope)this, name);
            ((ICustomScopeBindingListener)attribute).valueBound(event);
        }
        this.fireAttributeAdded(name, attribute);
    }

    public synchronized Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public synchronized Enumeration getAttributeNames() {
        return Collections.enumeration(new ArrayList(this.attributes.keySet()));
    }

    public synchronized void removeAttribute(String name) {
        Object old = this.attributes.remove(name);
        if (old != null) {
            this.fireAttributeRemoved(name, old);
            if (old instanceof ICustomScopeBindingListener) {
                CustomScopeBindingEvent event = new CustomScopeBindingEvent((ICustomScope)this, name);
                ((ICustomScopeBindingListener)old).valueUnbound(event);
            }
        }
    }

    public synchronized void destroy() {
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object attribute = entry.getValue();
            this.fireAttributeRemoved(name, attribute);
            if (!(attribute instanceof ICustomScopeBindingListener)) continue;
            CustomScopeBindingEvent event = new CustomScopeBindingEvent((ICustomScope)this, name);
            ((ICustomScopeBindingListener)attribute).scopeWillDestroy(event);
        }
        this.attributes.clear();
        this.fireScopeDestroyed();
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public synchronized void addScopeListener(HMCCustomScopeListener listener) {
        if (this.scopeListeners == null) {
            this.scopeListeners = new ArrayList(1);
        }
        this.scopeListeners.add(listener);
    }

    public synchronized void removeScopeListener(HMCCustomScopeListener listener) {
        if (this.scopeListeners == null) {
            return;
        }
        this.scopeListeners.remove(listener);
    }

    private void fireAttributeAdded(String name, Object attribute) {
        if (this.scopeListeners == null || this.scopeListeners.size() == 0) {
            return;
        }
        int len = this.scopeListeners.size();
        for (int i = 0; i < len; ++i) {
            HMCCustomScopeListener listener = (HMCCustomScopeListener)this.scopeListeners.get(i);
            listener.attributeAdded(this, name, attribute);
        }
    }

    private void fireAttributeRemoved(String name, Object attribute) {
        if (this.scopeListeners == null || this.scopeListeners.size() == 0) {
            return;
        }
        int len = this.scopeListeners.size();
        for (int i = 0; i < len; ++i) {
            HMCCustomScopeListener listener = (HMCCustomScopeListener)this.scopeListeners.get(i);
            listener.attributeRemoved(this, name, attribute);
        }
    }

    private void fireScopeDestroyed() {
        if (this.scopeListeners == null || this.scopeListeners.size() == 0) {
            return;
        }
        int len = this.scopeListeners.size();
        for (int i = 0; i < len; ++i) {
            HMCCustomScopeListener listener = (HMCCustomScopeListener)this.scopeListeners.get(i);
            listener.scopeDestroyed(this);
        }
    }
}

